/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.dsl;

import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.Token;
import io.gitlab.jfronny.commons.throwable.ThrowingConsumer;
import io.gitlab.jfronny.commons.throwable.ThrowingSupplier;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v2.Entry;
import io.gitlab.jfronny.libjf.config.api.v2.EntryInfo;
import io.gitlab.jfronny.libjf.config.api.v2.type.Type;
import io.gitlab.jfronny.libjf.config.impl.dsl.NothingSerializedException;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public class DslEntryInfo<T>
implements EntryInfo<T> {
    private final String name;
    private final T defaultValue;
    private final ThrowingSupplier<T, IllegalAccessException> get;
    private final ThrowingConsumer<T, IllegalAccessException> set;
    private final Type type;
    private final int width;
    private final double minValue;
    private final double maxValue;

    public DslEntryInfo(String name, T defaultValue, ThrowingSupplier<T, IllegalAccessException> get, ThrowingConsumer<T, IllegalAccessException> set, Type type, int width, double minValue, double maxValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.get = get;
        this.set = set;
        this.type = type;
        this.width = width;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public DslEntryInfo(String name, T def, ThrowingSupplier<T, IllegalAccessException> get, ThrowingConsumer<T, IllegalAccessException> set, Type type) {
        this(name, def, get, set, type, 100, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public static DslEntryInfo<Object> ofField(Field field) {
        Entry entry = field.getAnnotation(Entry.class);
        Object defaultValue = null;
        try {
            defaultValue = field.get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return new DslEntryInfo<Object>(field.getName(), defaultValue, () -> field.get(null), v -> field.set(null, v), Type.ofClass(field.getGenericType()), entry == null ? 100 : entry.width(), entry == null ? Double.NEGATIVE_INFINITY : entry.min(), entry == null ? Double.POSITIVE_INFINITY : entry.max());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T getDefault() {
        return this.defaultValue;
    }

    @Override
    public T getValue() throws IllegalAccessException {
        return (T)this.get.get();
    }

    @Override
    public void setValue(T value) throws IllegalAccessException {
        this.set.accept(value);
    }

    @Override
    public Type getValueType() {
        return this.type;
    }

    @Override
    public void fix() {
        Object value;
        try {
            value = this.getValue();
        }
        catch (IllegalAccessException e) {
            LibJf.LOGGER.error("Could not read value", (Throwable)e);
            return;
        }
        T valueOriginal = value;
        if (value instanceof Integer) {
            Integer v = (Integer)value;
            if ((double)v.intValue() < this.minValue) {
                value = (int)this.minValue;
            }
            if ((double)v.intValue() > this.maxValue) {
                value = (int)this.maxValue;
            }
        } else if (value instanceof Float) {
            Float v = (Float)value;
            if ((double)v.floatValue() < this.minValue) {
                value = Float.valueOf((float)this.minValue);
            }
            if ((double)v.floatValue() > this.maxValue) {
                value = Float.valueOf((float)this.maxValue);
            }
        } else if (value instanceof Double) {
            Double v = (Double)value;
            if (v < this.minValue) {
                value = this.minValue;
            }
            if (v > this.maxValue) {
                value = this.maxValue;
            }
        }
        if (valueOriginal != value) {
            try {
                this.setValue(this.cast(value));
            }
            catch (IllegalAccessException e) {
                LibJf.LOGGER.error("Could not write value", (Throwable)e);
            }
        }
    }

    @Override
    public <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>> T deserializeOneFrom(Reader reader) throws TEx, MalformedDataException {
        T t;
        Token next = reader.peek();
        Type type = this.type;
        Objects.requireNonNull(type);
        Type type2 = type;
        int n = 0;
        block21: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Type.TBool.class, Type.TBool.class, Type.TString.class, Type.TString.class, Type.TString.class, Type.TString.class, Type.TInt.class, Type.TInt.class, Type.TLong.class, Type.TLong.class, Type.TDouble.class, Type.TDouble.class, Type.TFloat.class, Type.TFloat.class, Type.TEnum.class, Type.TEnum.class, Type.TUnknown.class}, (Object)type2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Type.TBool tb = (Type.TBool)type2;
                    if (next != Token.BOOLEAN) {
                        n = 1;
                        continue block21;
                    }
                    T t2 = this.cast(reader.nextBoolean());
                    t = t2;
                    break block21;
                }
                case 1: {
                    T t3;
                    Type.TBool tb = (Type.TBool)type2;
                    t = t3 = DslEntryInfo.unexpectedValue(this.name, "boolean", next);
                    break block21;
                }
                case 2: {
                    Type.TString ts = (Type.TString)type2;
                    if (next != Token.STRING && next != Token.NUMBER) {
                        n = 3;
                        continue block21;
                    }
                    T t4 = this.cast(reader.nextString());
                    t = t4;
                    break block21;
                }
                case 3: {
                    Type.TString ts = (Type.TString)type2;
                    if (next != Token.BOOLEAN) {
                        n = 4;
                        continue block21;
                    }
                    T t5 = this.cast(Boolean.toString(reader.nextBoolean()));
                    t = t5;
                    break block21;
                }
                case 4: {
                    Type.TString ts = (Type.TString)type2;
                    if (next != Token.NUMBER) {
                        n = 5;
                        continue block21;
                    }
                    reader.nextNull();
                    T t6 = this.cast(null);
                    t = t6;
                    break block21;
                }
                case 5: {
                    T t7;
                    Type.TString ts = (Type.TString)type2;
                    t = t7 = DslEntryInfo.unexpectedValue(this.name, "string", next);
                    break block21;
                }
                case 6: {
                    Type.TInt ti = (Type.TInt)type2;
                    if (next != Token.NUMBER) {
                        n = 7;
                        continue block21;
                    }
                    T t8 = this.cast(reader.nextInt());
                    t = t8;
                    break block21;
                }
                case 7: {
                    T t9;
                    Type.TInt ti = (Type.TInt)type2;
                    t = t9 = DslEntryInfo.unexpectedValue(this.name, "number", next);
                    break block21;
                }
                case 8: {
                    Type.TLong tl = (Type.TLong)type2;
                    if (next != Token.NUMBER) {
                        n = 9;
                        continue block21;
                    }
                    T t10 = this.cast(reader.nextLong());
                    t = t10;
                    break block21;
                }
                case 9: {
                    T t11;
                    Type.TLong tl = (Type.TLong)type2;
                    t = t11 = DslEntryInfo.unexpectedValue(this.name, "number", next);
                    break block21;
                }
                case 10: {
                    Type.TDouble tb = (Type.TDouble)type2;
                    if (next != Token.NUMBER) {
                        n = 11;
                        continue block21;
                    }
                    T t12 = this.cast(reader.nextDouble());
                    t = t12;
                    break block21;
                }
                case 11: {
                    T t13;
                    Type.TDouble tb = (Type.TDouble)type2;
                    t = t13 = DslEntryInfo.unexpectedValue(this.name, "number", next);
                    break block21;
                }
                case 12: {
                    Type.TFloat tf = (Type.TFloat)type2;
                    if (next != Token.NUMBER) {
                        n = 13;
                        continue block21;
                    }
                    T t14 = this.cast(Float.valueOf((float)reader.nextDouble()));
                    t = t14;
                    break block21;
                }
                case 13: {
                    T t15;
                    Type.TFloat tf = (Type.TFloat)type2;
                    t = t15 = DslEntryInfo.unexpectedValue(this.name, "number", next);
                    break block21;
                }
                case 14: {
                    Type.TEnum te = (Type.TEnum)type2;
                    if (next != Token.STRING) {
                        n = 15;
                        continue block21;
                    }
                    T t16 = this.cast(te.optionForString(reader.nextString()));
                    t = t16;
                    break block21;
                }
                case 15: {
                    T t17;
                    Type.TEnum te = (Type.TEnum)type2;
                    t = t17 = DslEntryInfo.unexpectedValue(this.name, "string", next);
                    break block21;
                }
                case 16: {
                    Type.TUnknown tu = (Type.TUnknown)type2;
                    try {
                        T t18 = this.cast(LibJf.MAPPER.getAdapter(this.type.asToken()).deserialize(reader));
                        t = t18;
                        break block21;
                    }
                    catch (MalformedDataException e) {
                        LibJf.LOGGER.error("Could not read " + this.name, (Throwable)e);
                        throw new NothingSerializedException();
                    }
                }
            }
            break;
        }
        return t;
    }

    private static <T> T unexpectedValue(String name, String expected, Token instead) {
        LibJf.LOGGER.error("Unexpected value for " + name + ": expected " + expected + " but got " + String.valueOf(instead), new Object[0]);
        throw new NothingSerializedException();
    }

    private T cast(Object object) {
        return (T)object;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public double getMinValue() {
        return this.minValue;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue;
    }
}

